
local DST = rawget(_G, "DST") or {}
DST.SkillTooltips = DST.SkillTooltips or {}
local ST = DST.SkillTooltips

DST.Options = DST.Options or {}
local OPS = DST.Options

local options = PZAPI.ModOptions:create("EURY_DST", "Detailed Skill Tooltips")

OPS.showAutoLearnRecipes = options:addTickBox(
    "showAutoLearnRecipes",
    ST.getText("IGUI_DST_Option_AutoLearn"),
    true,
    ST.getText("IGUI_DST_Option_AutoLearn_tooltip")
)

OPS.showUnlockCraftRecipes = options:addTickBox(
    "showUnlockCraftRecipes",
    ST.getText("IGUI_DST_Option_UnlockCraft"),
    false,
    ST.getText("IGUI_DST_Option_UnlockCraft_tooltip")
)

OPS.showUnlockBuildRecipes = options:addTickBox(
    "showUnlockBuildRecipes",
    ST.getText("IGUI_DST_Option_UnlockBuild"),
    false,
    ST.getText("IGUI_DST_Option_UnlockBuild_tooltip")
)

options:addSeparator()

OPS.limitAutoLearnRecipesLabel = options:addDescription(
    ST.getText("IGUI_DST_Option_UnlimitedHint")
)

OPS.limitAutoLearnRecipes = options:addSlider(
    "limitAutoLearnRecipes",
    ST.getText("IGUI_DST_Option_AutoLearnLimit"),
    0,   -- min (0 = Unlimited)
    100, -- max
    1,   -- step
    0,   -- default (Unlimited)
    ST.getText("IGUI_DST_Option_AutoLearnLimit_tooltip")
)

OPS.limitCraftRecipes = options:addSlider(
    "limitCraftRecipes",
    ST.getText("IGUI_DST_Option_CraftRecipesLimit"),
    0, 100, 1, 0,
    ST.getText("IGUI_DST_Option_CraftRecipesLimit_tooltip")
)

OPS.limitBuildRecipes = options:addSlider(
    "limitBuildRecipes",
    ST.getText("IGUI_DST_Option_BuildRecipesLimit"),
    0, 100, 1, 0,
    ST.getText("IGUI_DST_Option_BuildRecipesLimit_tooltip")
)

options:addSeparator()
options:addDescription("IGUI_DST_Option_Foraging")

OPS.enableForagingLootUnlocks = options:addTickBox(
    "enableForagingLootUnlocks",
    ST.getText("IGUI_DST_Option_ForagingLootUnlocks"),
    false,
    ST.getText("IGUI_DST_Option_ForagingLootUnlocks_tooltip")
)

OPS.enableForagingRareLootUnlocks = options:addTickBox(
    "enableForagingRareLootUnlocks",
    ST.getText("IGUI_DST_Option_ForagingRareLootUnlocks"),
    false,
    ST.getText("IGUI_DST_Option_ForagingRareLootUnlocks_tooltip")
)

function options:apply()
    triggerEvent("DST_ForagingRebuild")
end

-- ==========================================================
-- Helpers
-- ==========================================================

function OPS.getEffectiveAutoLearnCap()     return tonumber(OPS.limitAutoLearnRecipes:getValue()) or 0 end
function OPS.getEffectiveCraftCap()         return tonumber(OPS.limitCraftRecipes:getValue())     or 0 end
function OPS.getEffectiveBuildCap()         return tonumber(OPS.limitBuildRecipes:getValue())     or 0 end
function OPS.isForagingLootEnabled()        return OPS.enableForagingLootUnlocks:getValue()       end
function OPS.isForagingRareLootEnabled()    return OPS.enableForagingRareLootUnlocks:getValue()   end